/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.AutoSurveyRunSurvey;
import com.ibm.hsc.auiml.databeans.ucode.GroupInformation;
import com.ibm.hsc.auiml.databeans.ucode.GroupItem;
import com.ibm.hsc.auiml.databeans.ucode.InfoPanel;
import com.ibm.hsc.auiml.databeans.ucode.OverviewSurveyBeanExt;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeLauncherUtil;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.ucode.UcodeSurveyException;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AutoSurveyResults
extends AuimlDataBeanAdapter
implements DataBean,
TaskActionListener,
TaskNotifyCompleteListener {
    public static final int PARTID_COLUMN = 0;
    public static final int ACT_COLUMN = 1;
    public static final int RES_COLUMN = 2;
    public static final int MACHINE_COLUMN = 3;
    public static final int MTMS_COLUMN = 4;
    public static final int ILVL_COLUMN = 5;
    public static final int RLVL_COLUMN = 6;
    public static final int IMPACT_COLUMN = 7;
    public static final int SUGGEST_COLUMN = 8;
    public static final int NUM_COLUMNS = 9;
    public static final String RESOURCE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "RESOURCE_VALUE", "Logical Device");
    public static final String MTMS_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MTMS_VALUE", "MTMS");
    public static final String MACHINE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MACHINE_VALUE", "Device");
    public static final String SUGGESTED_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "SUGGESTED_VALUE", "Suggested");
    public static final String COLUMN_RESOURCE = "LogicalDevice";
    public static final String COLUMN_MTMS = "MTMSNumber";
    public static final String COLUMN_MACHINE = "DeviceName";
    public static final String COLUMN_SUGGESTED = "SuggestedAction";
    public static final String CHECKED = "TRUE";
    public static final String UNCHECKED = "FALSE";
    public static final String SORTABLE = "TRUE";
    public static final String UNSORTABLE = "FALSE";
    public static final String ENABLED = "YES";
    public static final String DISABLED = "NO";
    public static final String SERVICE_LEVEL = "ServiceLevel";
    public static final String SORT_BOX = "SortBy";
    public static final String RESOURCE_TABLE = "SurveyResponseTable";
    public static final String AUTO = "Auto";
    public static final String NOT_FOUND = SurveyFileResult.notFound;
    private static final String HTMLUlineBegin = "<html> <B>";
    private static final String HTMLUlineEnd = "</B> </html>";
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    protected RepositoryItem _repos;
    protected List surveyResults;
    protected SurveyFileResult[] inSurveyFile = null;
    protected ResourceList srv_res;
    protected String currentServiceLevel;
    protected String rlvl;
    public int numObjects;
    private ArrayList osRows = new ArrayList(100);
    private String m_sReposLocation;
    OverviewSurveyBeanExt overviewBean;
    boolean currentSystemLevel = true;

    public AutoSurveyResults(RepositoryItem repositoryItem, OverviewSurveyBeanExt overviewSurveyBeanExt) {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults()");
        this.setOverviewBean(overviewSurveyBeanExt);
        this._repos = repositoryItem;
        this.setReposLocation(repositoryItem.toString());
        this.surveyResults = new ArrayList();
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults()");
    }

    public void setOverviewBean(OverviewSurveyBeanExt overviewSurveyBeanExt) {
        this.overviewBean = overviewSurveyBeanExt;
    }

    public int getResourceTableSize() {
        return this.numObjects;
    }

    public List getResourceList() {
        return this.surveyResults;
    }

    public ResourceList getResources() {
        return this.srv_res;
    }

    public OverviewSurveyBeanExt getOverviewBean() {
        return this.overviewBean;
    }

    public RepositoryItem getReposLevel() {
        return this._repos;
    }

    public void setUseCurrentLevel(boolean bl) {
        this.currentSystemLevel = bl;
    }

    public boolean getUseCurrentLevel() {
        return this.currentSystemLevel;
    }

    public void populateSortOptions() {
        UserTaskManager userTaskManager = this.getUTM();
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().populateSortOptions");
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(RESOURCE_VALUE, RESOURCE_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(MTMS_VALUE, MTMS_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(MACHINE_VALUE, MACHINE_VALUE));
        userTaskManager.addValidValue(SORT_BOX, null, new ValueDescriptor(SUGGESTED_VALUE, SUGGESTED_VALUE));
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().populateSortOptions");
    }

    public void populateServiceLevel(String string) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().populateServiceLevels");
        UserTaskManager userTaskManager = this.getUTM();
        if (string == null) {
            Trace.trace(TRACE_MASKF, "No service levels available...");
            Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().populateServiceLevels");
            return;
        }
        try {
            userTaskManager.setValue(SERVICE_LEVEL, string);
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKT, "<-AutoSurveyResults.populateServiceLevels() caught Exception: " + exception);
            throw new UcodeSurveyException("0028");
        }
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().PopulateServiceLevels");
    }

    public void populateResults(boolean bl, boolean bl2) {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().populateResults");
        boolean bl3 = false;
        boolean bl4 = false;
        UserTaskManager userTaskManager = this.getUTM();
        try {
            this.removeAllRows();
            if (!bl) {
                this.surveyResults.addAll(this.doSurvey(this._repos));
            }
            Trace.trace(TRACE_MASKD, "Surveys have been completed");
            if (this.surveyResults == null) {
                Trace.trace(TRACE_MASKF, "No SurveyResults available...");
                Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().PopulateResults");
                return;
            }
            if (this.surveyResults.size() == 0) {
                Trace.trace(TRACE_MASKF, "No SurveyResults available...");
                Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().PopulateResults");
                InfoPanel infoPanel = new InfoPanel("0059", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0059", "NO resources have been successfully surveyed.  There may be devices off line or other errors displayed."));
                UcodeLauncherUtil.launchInformationMessage(userTaskManager, infoPanel);
                return;
            }
            Iterator iterator = this.surveyResults.iterator();
            if (iterator == null) {
                Trace.trace(TRACE_MASKF, "No SurveyResults available...");
                Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().PopulateResults");
                return;
            }
            int n = 0;
            int n2 = 0;
            String string = "";
            Trace.trace(TRACE_MASKT, "Starting loop of resources");
            boolean bl5 = true;
            boolean bl6 = false;
            while (iterator.hasNext()) {
                Object object;
                ResourceItem resourceItem = (ResourceItem)iterator.next();
                bl5 = true;
                if (resourceItem.getResourceType() == 3) {
                    if (resourceItem.getSRVPAR().equals("Y")) {
                        bl5 = true;
                        bl6 = true;
                    } else if (!bl6) {
                        bl5 = true;
                        bl6 = true;
                    } else {
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[9];
                String[] stringArray = new String[5];
                stringArray[0] = resourceItem.getPARID();
                stringArray[1] = resourceItem.getDEVNM();
                if (resourceItem.getResourceType() == 1) {
                    itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, resourceItem.getName());
                    itemDescriptorArray[2] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 2, " ");
                    object = new Integer(n);
                    this.osRows.add(object);
                    Trace.trace(TRACE_MASKD, "osRows[" + n2 + "]=" + this.osRows.get(n2));
                    ++n2;
                } else {
                    if (resourceItem.getResourceType() == 6) {
                        itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, "BPA");
                        object = new Integer(n);
                        this.osRows.add(object);
                        ++n2;
                    } else {
                        itemDescriptorArray[0] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 0, " ");
                    }
                    itemDescriptorArray[2] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 2, resourceItem.getDEVNM());
                }
                itemDescriptorArray[3] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 3, resourceItem.getMachine());
                itemDescriptorArray[4] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 4, resourceItem.getMTMS());
                string = resourceItem.suggest(bl2);
                object = "FALSE";
                Trace.trace(TRACE_MASKD, "ISMAN is " + resourceItem.getISMAN());
                if (resourceItem.getISMAN().equals("Y")) {
                    Trace.trace(TRACE_MASKD, "row[" + n + "] can be Managed");
                    stringArray[2] = "TRUE";
                    object = resourceItem.getSuggest() == 1 ? "TRUE" : "FALSE";
                    Trace.trace(TRACE_MASKD, "row[" + n + "] checked=" + (String)object);
                } else {
                    object = "FALSE";
                    stringArray[2] = "FALSE";
                    Trace.trace(TRACE_MASKD, "row[" + n + "] checked set to " + (String)object);
                }
                String string2 = "SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 1;
                itemDescriptorArray[1] = new ItemDescriptor(string2, (String)object);
                Trace.trace(TRACE_MASKD, "row[" + n + "] checked=" + (String)object);
                stringArray[3] = "TRUE";
                if (this.checkEnableRow(resourceItem, stringArray)) {
                    stringArray[4] = ENABLED;
                    Trace.trace(TRACE_MASKD, "row[" + n + "] enabled=" + ENABLED);
                } else {
                    stringArray[4] = DISABLED;
                    Trace.trace(TRACE_MASKD, "row[" + n + "] enabled=" + DISABLED);
                }
                itemDescriptorArray[4].setUserObject((Object)stringArray);
                itemDescriptorArray[5] = new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 5, resourceItem.getCurrentLevel());
                itemDescriptorArray[6] = bl2 ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 6, resourceItem.getAvailableLevel()) : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 6, resourceItem.getPreviousLevel());
                itemDescriptorArray[7] = resourceItem.getResourceType() == 1 ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 7, " ") : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 7, resourceItem.getImpact());
                itemDescriptorArray[8] = resourceItem.getResourceType() == 1 ? new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 8, " ") : new ItemDescriptor("SurveyResponseTable." + System.currentTimeMillis() + "." + n + "." + 8, string);
                userTaskManager = this.getUTM();
                userTaskManager.addRow(RESOURCE_TABLE, n, itemDescriptorArray);
                resourceItem.setTableRow(n);
                ++n;
            }
            this.numObjects = n;
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, "Exception " + exception + " populating SurveyResult table.");
        }
        this.sortAlpha(RESOURCE_TABLE, 2, this.osRows);
        Trace.trace(TRACE_MASKD, "Number of items in result table is " + this.numObjects);
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().PopulateResults");
    }

    protected void enableRows(UserTaskManager userTaskManager) {
        int n = 0;
        while (n < this.numObjects) {
            ItemDescriptor[] itemDescriptorArray = userTaskManager.getRow(RESOURCE_TABLE, n);
            String string = itemDescriptorArray[1].getTitle();
            String string2 = itemDescriptorArray[1].getName();
            if (string.equals("TRUE")) {
                userTaskManager.setEnabled(string2, true);
                Trace.trace(TRACE_MASKD, "row[" + n + "] setEnabled=true");
            } else {
                userTaskManager.setEnabled(string2, false);
                Trace.trace(TRACE_MASKD, "row[" + n + "] setEnabled=false");
            }
            ++n;
        }
    }

    protected void removeAllRows() {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().removeAllRows");
        UserTaskManager userTaskManager = this.getUTM();
        try {
            while (true) {
                userTaskManager.removeRow(RESOURCE_TABLE, 0);
            }
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().removeAllRows");
            return;
        }
    }

    protected boolean checkEnableRow(ResourceItem resourceItem, String[] stringArray) {
        if (resourceItem.getResourceType() == 1 || !resourceItem.getISMAN().equals("Y")) {
            Trace.trace(TRACE_MASKD, "Either OS or not managed");
            stringArray[3] = "FALSE";
            return false;
        }
        if (resourceItem.getResourceType() == 3 && !resourceItem.getSRVPAR().equals("Y")) {
            Trace.trace(TRACE_MASKD, "System & not Service Partition");
            return false;
        }
        if (resourceItem.getResourceType() == 6) {
            Trace.trace(TRACE_MASKD, "BPA, can't sort");
            stringArray[3] = "FALSE";
        }
        if (resourceItem.getSuggest() != 1) {
            Trace.trace(TRACE_MASKD, "Not Upgrade");
            return false;
        }
        return true;
    }

    public void setRepos(RepositoryItem repositoryItem) {
        Trace.trace(TRACE_MASKT, "-> setRepos()");
        this._repos = repositoryItem;
        this.getUTM().setValue("ReposLocation", this._repos.toString());
        Trace.trace(TRACE_MASKT, "<- setRepos()");
    }

    public RepositoryItem getRepos() {
        return this._repos;
    }

    public String getReposLocation() {
        return this.m_sReposLocation;
    }

    public void setReposLocation(String string) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setReposLocation() " + string);
        this.m_sReposLocation = string;
        Trace.trace(TRACE_MASKT, "<- setReposLocation() ");
    }

    public String getLatestServiceLevel() {
        return this.m_sReposLocation;
    }

    public String getPreviousServiceLevel() {
        return this.m_sReposLocation;
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().taskCompleted");
        String string = taskNotifyCompleteEvent.getElementName();
        Trace.trace(TRACE_MASKD, "Element Name: " + string);
        if (string.equals(SERVICE_LEVEL)) {
            this.currentServiceLevel = taskNotifyCompleteEvent.getValue();
            Trace.trace(TRACE_MASKD, "Current Service Level: " + this.currentServiceLevel);
            this.populateResults(true, this.getUseCurrentLevel());
        } else {
            String string2 = taskNotifyCompleteEvent.getValue();
            Trace.trace(TRACE_MASKD, "Value selected: " + string2);
            if (string2.equals(RESOURCE_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 2, this.osRows);
            } else if (string2.equals(MTMS_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 4, this.osRows);
            } else if (string2.equals(MACHINE_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 3, this.osRows);
            } else if (string2.equals(SUGGESTED_VALUE)) {
                this.sortAlpha(RESOURCE_TABLE, 8, this.osRows);
            }
        }
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().taskCompleted");
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().actionPerformed");
        String string = taskActionEvent.getElementName();
        try {
            Trace.trace(TRACE_MASKD, "Command is: " + string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().actionPerformed");
    }

    public List doSurvey(RepositoryItem repositoryItem) throws UcodeSurveyException {
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().doSurvey");
        GroupInformation groupInformation = this.overviewBean.getGroupList();
        GroupItem groupItem = this.overviewBean.groupList.findGroup("SEL-000");
        if (groupItem == null) {
            throw new UcodeSurveyException(HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0029", "Internal Error: Group not found error for Selected Group"));
        }
        Trace.trace(TRACE_MASKD, "Selected_Group found");
        UserTaskManager userTaskManager = this.getUTM();
        AutoSurveyRunSurvey autoSurveyRunSurvey = new AutoSurveyRunSurvey(userTaskManager);
        this.inSurveyFile = autoSurveyRunSurvey.runSurvey(groupItem, this.overviewBean);
        if (this.inSurveyFile == null || this.inSurveyFile[0] == null) {
            Trace.trace(TRACE_MASKF, "Survey File is null, exception/message should have been already done.");
            return new ArrayList(1);
        }
        String string = " ";
        this.srv_res = new ResourceList();
        int n = this.inSurveyFile.length;
        int n2 = 0;
        while (n2 < n) {
            Trace.trace(TRACE_MASKD, "Using Survey file inSurveyFile[" + n2 + "] of " + n);
            if (this.inSurveyFile[n2] == null) {
                Trace.trace(TRACE_MASKD, "No survey file at inSurveyFile[" + n2 + "] of " + n);
            } else {
                int n3 = this.inSurveyFile[n2].size();
                boolean bl = true;
                ResourceItem resourceItem = null;
                int n4 = 1;
                while (n4 < n3) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    String string9;
                    String string10;
                    String string11;
                    String string12;
                    String string13;
                    String string14;
                    String string15;
                    String string16;
                    String string17;
                    String string18;
                    int n5;
                    String string19;
                    String string20;
                    boolean bl2 = false;
                    String string21 = this.inSurveyFile[n2].findRecordIndex(n4);
                    String string22 = this.inSurveyFile[n2].getValue(string21, "REC");
                    Trace.trace(TRACE_MASKD, "Using record " + n4 + " of Survey file inSurveyFile[" + n2 + "] of " + n3);
                    if (string22.equals("HDR")) {
                        bl2 = false;
                        string = this.inSurveyFile[n2].getValue(string21, "CATDATE");
                        if (repositoryItem.getReposType() == 0) {
                            repositoryItem.setDirPath(this.inSurveyFile[n2].getValue(string21, "WEBPATH").trim());
                        }
                        if (repositoryItem.getReposType() == 4) {
                            repositoryItem.setDirPath(this.inSurveyFile[n2].getValue(string21, "FTPPATH").trim());
                        }
                        if (repositoryItem.getReposType() == 1) {
                            repositoryItem.setDirPath(this.inSurveyFile[n2].getValue(string21, "CDPATH").trim());
                        }
                    }
                    if (string22.equals("OS")) {
                        bl2 = true;
                        if (this.getOverviewBean().getProperty("location").equals("aix")) {
                            string20 = "000";
                            string19 = "Partition 000";
                        } else {
                            string20 = this.inSurveyFile[n2].getValue(string21, "PARID");
                            if (string20 != null && string20.trim().length() == 0) {
                                string20 = "000";
                            }
                            string19 = "Partition " + string20;
                        }
                        n5 = 1;
                        string18 = this.inSurveyFile[n2].getValue(string21, "MTMS");
                        if (bl) {
                            this.srv_res.addMTMS(string18);
                            bl = false;
                        }
                        string17 = this.inSurveyFile[n2].getValue(string21, "HOSTNAME");
                        string16 = this.inSurveyFile[n2].getValue(string21, "OSLVL");
                        string15 = this.inSurveyFile[n2].getValue(string21, "OSLVL");
                        string14 = this.inSurveyFile[n2].getValue(string21, "ISMAN");
                        string13 = "";
                        string12 = " ";
                        string11 = this.inSurveyFile[n2].getValue(string21, "REBOOT");
                        string10 = "";
                        string9 = "";
                        string8 = "";
                        string7 = "";
                        string6 = "";
                        string5 = this.inSurveyFile[n2].getValue(string21, "CONC");
                        string4 = "";
                        string3 = "";
                        string2 = "";
                        resourceItem = new ResourceItem(string19, n5, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                    }
                    if (string22.equals("SYS")) {
                        bl2 = true;
                        string19 = this.inSurveyFile[n2].getValue(string21, "DEVTYPE");
                        n5 = 3;
                        string18 = this.inSurveyFile[n2].getValue(string21, "MTMS");
                        if (bl) {
                            this.srv_res.addMTMS(string18);
                            bl = false;
                        }
                        string17 = this.inSurveyFile[n2].getValue(string21, "DESC");
                        string16 = this.determineCurrentLevel(this.inSurveyFile[n2], string21, string22);
                        string15 = this.determineAvailableLevel(this.inSurveyFile[n2], string21, string22);
                        string12 = this.determinePreviousLevel(this.inSurveyFile[n2], string21, string22);
                        string14 = this.inSurveyFile[n2].getValue(string21, "ISMAN");
                        string13 = this.inSurveyFile[n2].getValue(string21, "VFORM");
                        string11 = this.inSurveyFile[n2].getValue(string21, "REBOOT");
                        string10 = this.inSurveyFile[n2].getValue(string21, "RPMFILE");
                        if (this.inSurveyFile[n2].getValue(string21, "PARID").equals(NOT_FOUND)) {
                            string20 = "000";
                        } else {
                            string20 = this.inSurveyFile[n2].getValue(string21, "PARID");
                            if (string20 != null && string20.trim().length() == 0) {
                                string20 = "000";
                            }
                        }
                        string9 = this.inSurveyFile[n2].getValue(string21, "DEVNM");
                        string8 = this.inSurveyFile[n2].getValue(string21, "SRVPAR");
                        string7 = this.inSurveyFile[n2].getValue(string21, "IMGFILE");
                        string6 = this.inSurveyFile[n2].getValue(string21, "IMGFILE-1");
                        string5 = this.inSurveyFile[n2].getValue(string21, "CONC");
                        string4 = this.inSurveyFile[n2].getValue(string21, "CDDIR");
                        string3 = this.inSurveyFile[n2].getValue(string21, "WEBDIR");
                        string2 = this.inSurveyFile[n2].getValue(string21, "FTPDIR");
                        resourceItem = new ResourceItem(string19, n5, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                    }
                    if (string22.equals("DEV")) {
                        bl2 = true;
                        string19 = this.inSurveyFile[n2].getValue(string21, "DEVTYPE");
                        n5 = 2;
                        string18 = this.inSurveyFile[n2].getValue(string21, "MTMS");
                        if (bl) {
                            this.srv_res.addMTMS(string18);
                            bl = false;
                        }
                        string17 = this.inSurveyFile[n2].getValue(string21, "DESC");
                        string16 = this.determineCurrentLevel(this.inSurveyFile[n2], string21, string22);
                        string15 = this.determineAvailableLevel(this.inSurveyFile[n2], string21, string22);
                        string12 = "";
                        string14 = this.inSurveyFile[n2].getValue(string21, "ISMAN");
                        string13 = this.inSurveyFile[n2].getValue(string21, "VFORM");
                        string11 = this.inSurveyFile[n2].getValue(string21, "REBOOT");
                        string10 = this.inSurveyFile[n2].getValue(string21, "RPMFILE");
                        if (this.inSurveyFile[n2].getValue(string21, "PARID").equals(NOT_FOUND)) {
                            string20 = "000";
                        } else {
                            string20 = this.inSurveyFile[n2].getValue(string21, "PARID");
                            if (string20 != null && string20.trim().length() == 0) {
                                string20 = "000";
                            }
                        }
                        string9 = this.inSurveyFile[n2].getValue(string21, "DEVNM");
                        string8 = this.inSurveyFile[n2].getValue(string21, "SRVPAR");
                        string7 = this.inSurveyFile[n2].getValue(string21, "IMGFILE");
                        string6 = this.inSurveyFile[n2].getValue(string21, "IMGFILE-1");
                        string5 = this.inSurveyFile[n2].getValue(string21, "CONC");
                        string4 = this.inSurveyFile[n2].getValue(string21, "CDDIR");
                        string3 = this.inSurveyFile[n2].getValue(string21, "WEBDIR");
                        string2 = this.inSurveyFile[n2].getValue(string21, "FTPDIR");
                        resourceItem = new ResourceItem(string19, n5, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                    }
                    if (string22.equals("BPA")) {
                        String string23 = this.inSurveyFile[n2].getValue(string21, "MTMS").trim();
                        string18 = string23.indexOf("_") > 0 ? string23 : string23.substring(0, 8) + "_" + string23.substring(8);
                        if (groupItem.findResourceItem(string18) == null) {
                            Trace.trace(TRACE_MASKD, "BPA " + string18 + " not selected by user");
                        } else {
                            Trace.trace(TRACE_MASKD, "Creating BPA resource item for " + string18);
                            bl2 = true;
                            string19 = this.inSurveyFile[n2].getValue(string21, "DEVTYPE");
                            n5 = 6;
                            this.srv_res.addMTMS(string18);
                            string17 = this.inSurveyFile[n2].getValue(string21, "DESC");
                            string16 = this.determineCurrentLevel(this.inSurveyFile[n2], string21, string22);
                            string15 = this.determineAvailableLevel(this.inSurveyFile[n2], string21, string22);
                            string14 = this.inSurveyFile[n2].getValue(string21, "ISMAN");
                            string12 = this.inSurveyFile[n2].getValue(string21, "FDBINLVL2");
                            string13 = this.inSurveyFile[n2].getValue(string21, "VFORM");
                            string11 = this.inSurveyFile[n2].getValue(string21, "REBOOT");
                            string10 = this.inSurveyFile[n2].getValue(string21, "RPMFILE");
                            string20 = "BPA";
                            string9 = this.inSurveyFile[n2].getValue(string21, "DEVNM");
                            string8 = "";
                            string7 = this.inSurveyFile[n2].getValue(string21, "IMGFILE");
                            string6 = "";
                            string5 = this.inSurveyFile[n2].getValue(string21, "CONC");
                            string4 = this.inSurveyFile[n2].getValue(string21, "CDDIR");
                            string3 = this.inSurveyFile[n2].getValue(string21, "WEBDIR");
                            string2 = this.inSurveyFile[n2].getValue(string21, "FTPDIR");
                            resourceItem = new ResourceItem(string19, n5, string18, string17, string16, string15, string12, string11, string10, string20, string9, string8, string14, string13, string7, string6, string5, string4, string3, string2);
                        }
                    }
                    if (bl2) {
                        this.srv_res.addResource(resourceItem);
                    }
                    ++n4;
                }
                repositoryItem.setServiceLevels(string);
                try {
                    this.populateServiceLevel(string);
                }
                catch (UcodeSurveyException ucodeSurveyException) {
                    Trace.trace(TRACE_MASKF, "Exception " + ucodeSurveyException + " calling populateServiceLevels");
                    throw ucodeSurveyException;
                }
            }
            ++n2;
        }
        List list = this.srv_res.getResourceList();
        Trace.trace(TRACE_MASKD, "Assigned resources to Selected_Group");
        if (list.size() == 0) {
            Trace.trace(TRACE_MASKD, "No resources have been found, ");
        }
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().doSurvey");
        return list;
    }

    protected String determineCurrentLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        Trace.trace(TRACE_MASKD, "->determineCurrentLevel()");
        String string3 = "";
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVINLVL");
            }
            return surveyFileResult.getValue(string, "SYSINLVL");
        }
        if (string2.equals("DEV")) {
            string3 = surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND) ? surveyFileResult.getValue(string, "LDBINLVL") : surveyFileResult.getValue(string, "LSMINLVL");
            if (string3.equals(NOT_FOUND)) {
                return string3;
            }
            return this.determineLevel(surveyFileResult, string, string2, string3);
        }
        if (string2.equals("BPA")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBINLVL");
            }
            return surveyFileResult.getValue(string, "LSMINLVL");
        }
        Trace.trace(TRACE_MASKD, "ERROR, Record Type was not SYS, BPA or DEV ");
        Trace.trace(TRACE_MASKT, "<-determineCurrentLevel() ");
        return NOT_FOUND;
    }

    protected String determineAvailableLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        Trace.trace(TRACE_MASKD, "->determineAvailableLevel()");
        String string3 = " ";
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVLTLVL");
            }
            return surveyFileResult.getValue(string, "SYSLTLVL");
        }
        if (string2.equals("DEV")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBLTLVL");
            }
            return surveyFileResult.getValue(string, "LSMLTLVL");
        }
        if (string2.equals("BPA")) {
            if (surveyFileResult.getValue(string, "LSMLTLVL").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "LDBLTLVL");
            }
            return surveyFileResult.getValue(string, "LSMLTLVL");
        }
        Trace.trace(TRACE_MASKD, "ERROR, Record Type was not SYS, BPA or DEV ");
        Trace.trace(TRACE_MASKT, "<-determineAvailableLevel() ");
        return NOT_FOUND;
    }

    protected String determinePreviousLevel(SurveyFileResult surveyFileResult, String string, String string2) {
        Trace.trace(TRACE_MASKD, "->determinePreviousLevel()");
        if (string2.equals("SYS")) {
            if (surveyFileResult.getValue(string, "SYSLTLVL-1").equals(NOT_FOUND)) {
                return surveyFileResult.getValue(string, "SRVLTLVL-1");
            }
            return surveyFileResult.getValue(string, "SYSLTLVL-1");
        }
        return NOT_FOUND;
    }

    protected String determineLevel(SurveyFileResult surveyFileResult, String string, String string2, String string3) {
        String string4 = surveyFileResult.getValue(string, "LSMFORM");
        int n = 0;
        String string5 = "";
        if (string2.equals("DEV")) {
            if (string4.equals(NOT_FOUND)) {
                n = 0;
            } else {
                n = Integer.parseInt(string4.substring(0, 1));
                Trace.trace(TRACE_MASKD, "Number of tokens is: " + n);
                if (n > 0) {
                    string5 = string4.substring(1).trim();
                    Trace.trace(TRACE_MASKD, "Token Value is: " + string5);
                }
            }
            if (n == 0) {
                Trace.trace(TRACE_MASKD, "returning: " + string3);
                return string3;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if ((n2 = string3.indexOf(string5, n2 + 1)) == -1) {
                    return NOT_FOUND;
                }
                ++n3;
            }
            Trace.trace(TRACE_MASKD, "Beginning of value at position: " + n2);
            int n4 = string3.indexOf("|", n2 + 1);
            if (n4 == -1 && (n4 = string3.indexOf(string5, n2 + 1)) == -1) {
                n4 = string3.length();
            }
            Trace.trace(TRACE_MASKD, "End of value at position: " + n4);
            String string6 = string3.substring(n2 += string5.length(), n4);
            Trace.trace(TRACE_MASKD, "returning: " + string6);
            return string6;
        }
        Trace.trace(TRACE_MASKT, "<-determinePreviousLevel() ");
        return NOT_FOUND;
    }

    public void load() {
    }

    public void save() {
    }

    private void sortAlpha(String string, int n, ArrayList arrayList) {
        ItemDescriptor[] itemDescriptorArray;
        int n2;
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults.sortAlpha()");
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        ArrayList<ItemDescriptor[]> arrayList2 = new ArrayList<ItemDescriptor[]>(this.numObjects);
        boolean bl = false;
        ArrayList arrayList3 = new ArrayList();
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = arrayList.size();
        do {
            n3 = (Integer)arrayList.get(n5);
            n4 = n5 + 1 < n7 ? (Integer)arrayList.get(n5 + 1) - 1 : this.numObjects - 1;
            Trace.trace(TRACE_MASKD, "osRows[" + n5 + "]=" + arrayList.get(n5) + "  endRow=" + n4);
            n6 = n4 - n3 + 1;
            arrayList2.clear();
            n2 = n3;
            while (n2 <= n4) {
                ItemDescriptor[] itemDescriptorArray2 = this.getUTM().getRow(string, n2);
                arrayList2.add(itemDescriptorArray2);
                ++n2;
            }
            int n8 = 1;
            while (n8 < n6 - 1) {
                ItemDescriptor[] itemDescriptorArray3;
                Trace.trace(TRACE_MASKD, "AutoSurveyResults.sortAlpha() Sorting at array element " + n8);
                itemDescriptorArray = itemDescriptorArray3 = (ItemDescriptor[])arrayList2.get(n8);
                String string2 = itemDescriptorArray3[n].getTitle();
                int n9 = n8;
                int n10 = n8 + 1;
                while (n10 <= n6 - 1) {
                    ItemDescriptor[] itemDescriptorArray4 = (ItemDescriptor[])arrayList2.get(n10);
                    String string3 = itemDescriptorArray4[n].getTitle();
                    if (collator.compare(string2, string3) > 0) {
                        n9 = n10;
                        string2 = string3;
                        itemDescriptorArray = itemDescriptorArray4;
                    }
                    ++n10;
                }
                if (n9 != n8) {
                    arrayList2.set(n8, itemDescriptorArray);
                    arrayList2.set(n9, itemDescriptorArray3);
                    bl = true;
                }
                ++n8;
            }
            int n11 = n3;
            while (n11 <= n4) {
                arrayList3.add(n11, arrayList2.get(n11 - n3));
                ++n11;
            }
        } while (++n5 < n7);
        n2 = 0;
        while (n2 < this.numObjects) {
            this.getUTM().removeRow(string, 0);
            ++n2;
        }
        itemDescriptorArray = this.getUTM();
        int n12 = 0;
        while (n12 < this.numObjects) {
            ItemDescriptor[] itemDescriptorArray5 = (ItemDescriptor[])arrayList3.get(n12);
            String[] stringArray = (String[])itemDescriptorArray5[4].getUserObject();
            stringArray[2] = itemDescriptorArray5[1].getTitle();
            Trace.trace(TRACE_MASKD, "hiddenData 0:" + stringArray[0] + " 1:" + stringArray[1] + " 2:" + stringArray[2] + " 3:" + stringArray[3] + " 4:" + stringArray[4]);
            String string4 = "SurveyResponseTable." + System.currentTimeMillis() + "." + n12 + "." + 1;
            itemDescriptorArray5[1] = new ItemDescriptor(string4, stringArray[2]);
            itemDescriptorArray.addRow(string, n12, itemDescriptorArray5);
            ++n12;
        }
        if (!bl) {
            Trace.trace(TRACE_MASKT, "AutoSurveyResults.sortAlpha() table " + string + "  already sorted");
        }
        this.enableRows((UserTaskManager)itemDescriptorArray);
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults.sortAlpha()");
    }

    public void verifyChanges() {
        Object object;
        Trace.trace(TRACE_MASKT, "-> AutoSurveyResults().verifyChanges");
        UserTaskManager userTaskManager = this.getUTM();
        String string = "";
        int n = 0;
        while (n < this.numObjects) {
            object = userTaskManager.getRow(RESOURCE_TABLE, n);
            String string2 = object[2].getTitle();
            String string3 = object[4].getTitle();
            String string4 = object[3].getTitle();
            String string5 = string2 + "/" + string3 + "/" + string4;
            if (object[1].getTitle().equals("TRUE")) {
                string = string + string5 + "\n";
            }
            ++n;
        }
        object = new InfoPanel("0010", HSCResourceBundleUtil.getMessage("UcodeBundleMessages", "0010", "Function completed successfully"));
        UcodeLauncherUtil.launchInformationMessage(userTaskManager, (InfoPanel)object);
        Trace.trace(TRACE_MASKT, "<- AutoSurveyResults().verifyChanges");
    }

    public Capabilities getCapabilities() {
        return null;
    }
}

